/* VodafoneK3770.h */
/*
Copyright (C) 2012 ARM Limited.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#ifndef VODAFONEK3770_H_
#define VODAFONEK3770_H_

#error 'This library is deprecated. Please use the newest production branch of the library from https://mbed.org/users/mbed_official/code/VodafoneUSBModem/'

#include "core/fwk.h"

#include "USB3GModule/WANDongle.h"
#include "drv/at/ATCommandsInterface.h"
#include "drv/serial/usb/USBSerialStream.h"
#include "if/ip/PPPIPInterface.h"
#include "if/sms/SMSInterface.h"
#include "if/ussd/USSDInterface.h"

/** Vodafone K3770 dongle
 */
class VodafoneK3770
{
public:
  /** Create Vodafone K3770 dongle API instance

   */
  VodafoneK3770();

  //Internet-related functions

  /** Open a 3G internet connection
      @return 0 on success, error code on failure
  */
  int connect(const char* apn = NULL, const char* user = NULL, const char* password = NULL);

  /** Close the internet connection
     @return 0 on success, error code on failure
  */
  int disconnect();


  /** Send a SM
     @param number The receiver's phone number
     @param message The message to send
     @return 0 on success, error code on failure
   */
  int sendSM(const char* number, const char* message);


  /** Receive a SM
     @param number Pointer to a buffer to store the sender's phone number (must be at least 17 characters-long, including the sapce for the null-terminating char)
     @param message Pointer to a buffer to store the the incoming message
     @param maxLength Maximum message length that can be stored in buffer (including null-terminating character)
     @return 0 on success, error code on failure
   */
  int getSM(char* number, char* message, size_t maxLength);

  /** Get the number of SMs in the incoming box
     @param pCount pointer to store the number of unprocessed SMs on
     @return 0 on success, error code on failure
   */
  int getSMCount(size_t* pCount);

  /** Send a USSD command & wait for its result
    @param command The command to send
    @param result Buffer in which to store the result
    @param maxLength Maximum result length that can be stored in buffer (including null-terminating character)
    @return 0 on success, error code on failure
  */
  int sendUSSD(const char* command, char* result, size_t maxLength);

  /** Get the ATCommandsInterface instance
     @return Pointer to the ATCommandsInterface instance
   */
  ATCommandsInterface* getATCommandsInterface();

protected:
  int init();

private:
  WANDongle m_dongle;
  USBSerialStream m_stream;
  ATCommandsInterface m_at;
  PPPIPInterface m_ppp;
  SMSInterface m_sms;
  USSDInterface m_ussd;

  bool m_dongleConnected;
  bool m_ipInit;
  bool m_smsInit;
  bool m_ussdInit;
  bool m_atOpen;
};


#endif /* VODAFONEK3770_H_ */
