#include "mbed.h"
#include "UMTSStickNetIf.h"
#include "HTTPClient.h"

UMTSStickNetIf stick; 
HTTPClient http;
  
int main() {

  printf("Setting up...\n");
  UMTSStickErr umtsStickErr = stick.setup();
  if(umtsStickErr)
  {
    printf("Error %d in setup.\n", umtsStickErr);
    return -1;
  }
  printf("Setup OK\r\n");
  
  PPPErr pppErr;
  printf("Connecting...\n");
  pppErr = stick.connect("internet", "web", "web");
  //pppErr = stick.connect("three.co.uk", NULL, NULL);
  //pppErr = stick.connect("pp.vodafone.co.uk", "web", "web");
  //pppErr = stick.connect(NULL, NULL, NULL);
  if(pppErr)
  {
    printf("Error %d during connection.\n", pppErr);
    return -1;
  }

  HTTPText txt;
  
  HTTPResult r = http.get("http://mbed.org/media/uploads/donatien/hello.txt", &txt);
  if(r==HTTP_OK)
  {
    printf("Result :\"%s\"\n", txt.gets()); 
  }
  else
  {
    printf("Error %d\n", r);
  }
  
  printf("Disconnecting.\n");
   
  stick.disconnect();

  printf("Disconnected.\n");
  
  while(1)
  {
  
  }
  
  return 0;
  
}
