#include "mbed.h"
#include "SprintUSBModem.h"
#include "Websocket.h"

void test(void const*) 
{
    SprintUSBModem modem(p18);  
    Websocket ws("ws://sockets.mbed.org:443/ws/demo/rw");
    char recv[128];
    
    Thread::wait(5000);
    printf("Switching power on\r\n");
    
    modem.power(true);
    
    int ret = modem.connect();
    if(ret)
    {
      printf("Could not connect\r\n");
      return;
    }
    
    bool c = ws.connect();
    printf("Connect result: %s\r\n", c?"OK":"Failed");
    
    for(int i = 0; i < 10000; i++)
    {
        if(!(i%100))
        {
          int ret = ws.send("WebSocket Hello World!");
          if(ret<0)
          {
            printf("Timeout\r\n");
            ws.close();
            c = ws.connect();
            printf("Connect result: %s\r\n", c?"OK":"Failed");
          }
        }
        
        if (ws.read(recv)) {
            printf("rcv: %s\r\n", recv);
        }

    }
    
    modem.disconnect();  
    
    printf("Disconnected\r\n");
    
    modem.power(false); 
    
    printf("Powered off\r\n");

    while(1) {
    }
}


int main()
{
  DBG_INIT();
  DBG_SET_SPEED(115200);
  DBG_SET_NEWLINE("\r\n");
  Thread testTask(test, NULL, osPriorityNormal, 1024 * 5);
  DigitalOut led(LED1);
  while(1)
  {
    led=!led;
    Thread::wait(1000);  
  }

  return 0;
}
