#include "mbed.h"
#include "SprintUSBModem.h"

#define MY_PHONE_NUMBER "+1xxxxxxxxx"

void test(void const*) 
{
    SprintUSBModem modem(p18);

    printf("Switching power on\r\n");
    
    modem.power(true);
    
    modem.sendSM(MY_PHONE_NUMBER, "Hello from mbed:)");

    while(true)
    {
        char num[17];
        char msg[128];
        size_t count;
        int ret = modem.getSMCount(&count);
        if(ret)
        {
          printf("getSMCount returned %d\r\n", ret);
          Thread::wait(3000);
          continue;
        }
        if( count > 0)
        {
          printf("%d SMS to read\r\n", count);
          ret = modem.getSM(num, msg, 128);
          if(ret)
          {
            printf("getSM returned %d\r\n", ret);
            Thread::wait(3000);
            continue;
          }
    
          printf("%s : %s\r\n", num, msg);
        }
        Thread::wait(3000);
    }    
    
    modem.disconnect(); 
    
    modem.power(false); 

    while(1) {
    }
}


int main()
{
  DBG_INIT();
  DBG_SET_SPEED(115200);
  DBG_SET_NEWLINE("\r\n");
  Thread testTask(test, NULL, osPriorityNormal, 1024 * 5);
  DigitalOut led(LED1);
  while(1)
  {
    led=!led;
    Thread::wait(1000);  
  }

  return 0;
}
