#include "mbed.h"
#include "SprintUSBModem.h"
#include "NTPClient.h"

void test(void const*) 
{
    SprintUSBModem modem(p18);
    NTPClient ntp;
    
    Thread::wait(5000);
    printf("Switching power on\r\n");
    
    modem.power(true);
    
    int ret = modem.connect();
    if(ret)
    {
      printf("Could not connect\r\n");
      return;
    }
    
    printf("Trying to update time...\r\n");
    if (ntp.setTime("0.pool.ntp.org") == 0)
    {
      printf("Set time successfully\r\n");
      time_t ctTime;
      ctTime = time(NULL);
      printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
    }
    else
    {
      printf("Error\r\n");
    } 
    
    printf("Disconnecting\r\n");
    
    modem.disconnect(); 
    
    printf("Disconnected\r\n");
    
    modem.power(false); 
    
    printf("Powered off\r\n");

    while(1) {
    }
}


int main()
{
  DBG_INIT();
  DBG_SET_SPEED(115200);
  DBG_SET_NEWLINE("\r\n");
  Thread testTask(test, NULL, osPriorityNormal, 1024 * 5);
  DigitalOut led(LED1);
  while(1)
  {
    led=!led;
    Thread::wait(1000);  
  }

  return 0;
}
