/*
Copyright (c) 2010 ARM Limited

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/*
Initialization and closing routines for Ethernet interface, and program entry point.
*/

//Core libs
#include "mbed.h"

//Network
#include "EthernetNetIf.h"

EthernetNetIf eth; 

int network_init()
{
  while(1)
  {
    printf("Start\n");

    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
      printf("\r\nCould not connect... trying again!\r\n");
      continue;
    }
    break;
  }
  
  IpAddr myIp = eth.getIp();

  printf("Ip Address: %d.%d.%d.%d\n", myIp[0], myIp[1], myIp[2], myIp[3]);

  return 0;
}

int network_close()
{
  return 0;
}
