/*
Copyright (c) 2010 ARM Limited

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "mbed.h"
#include "beep.h"

Beep::Beep(PinName pin) : m_ticker(), m_timeout(), m_out(pin)
{
  m_part = NULL;
  m_pos = 0;
}

Beep::~Beep()
{

}

//Tones data is { freq1 (Hz), length1 (s), ... } 
//For a pause, frequency is set to 0
//If length=0, end of tone
const float Beep::Tones[][8] = { {523.25, 0.025, 783.99, 0.075, 0, 0}, //TONE_OK,
                          {440, 0.050, 0, 0}, //TONE_INFO,
                          {220, 0.100, 0, 0}, //TONE_WARN,
                          {110, 0.250, 0, 0}  //TONE_ERR
                        };
  
void Beep::beep(BEEP_TONE tone) //New beep
{
  m_ticker.detach(); //Stop previous beep is existing
  m_timeout.detach();
  m_part = (float*) Beep::Tones[tone]; //Select tone buf
  m_pos = 0;
  beepNote(); //Start with first note
}

void Beep::beepNote()
{
  float freq = m_part[m_pos]; //Setup frequency and length
  float len = m_part[m_pos+1];
  m_pos+=2;
  if(len==0)
    beepDone();
  m_timeout.attach(this, &Beep::beepDone, len); //Setup timeout for end of note
  if(freq>0)
    m_ticker.attach(this, &Beep::beepTick, .5/freq); //Setup ticker for pin toggling at right freq
}

void Beep::beepTick()
{
  m_out.write(!m_out.read()); //Toggle output pin
}

void Beep::beepDone()
{
  m_ticker.detach(); //Note is done, stop toggling output pin
}