/*
Copyright (c) 2010 ARM Limited

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/*
This is a specific and quick implementation for the Mifare MicroRWD modules.
The class configures the reader for Mifare operation and can poll for UIDs.
*/

#ifndef RWD_MIFARE_H
#define RWD_MIFARE_H

#include "mbed.h"
#include "RWDModule.h"

class RWDMifare : public RWDModule
{
public:
  RWDMifare(PinName tx, PinName rx, PinName cts);
  virtual ~RWDMifare();
  
  enum RWDMifareErr
  {
    MIFARE_OK, //No error
    MIFARE_HW, //Hardware-specific error
    MIFARE_NOCARD, //No card in field
    MIFARE_WRONGKEY //Key is not valid (for auth command)
  };

  //Initialize the reader to operate in Mifare mode
  RWDMifareErr init();
  
  //Checks if a card is present, and if so gets its UID
  //Returns UID length as well (4, 7, or 10-bytes long)
  RWDMifareErr getUID(uint8_t* pUID, size_t* pLen); //pUID must be at least 10-bytes long

};

#endif
