/*
Copyright (c) 2010 ARM Limited

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "RWDMifare.h"

RWDMifare::RWDMifare(PinName tx, PinName rx, PinName cts) : RWDModule(tx, rx, cts)
{

}

RWDMifare::~RWDMifare()
{

}
  
RWDMifare::RWDMifareErr RWDMifare::init()
{
  const uint8_t config[] = {0x03, 0x00}; //Configure ready for Mifare Op (0x00 to addr 0x03 in EEPROM)
  uint8_t resp[64] = {0};
  //Cf http://www.ibtechnology.co.uk/pdf/MF_ICprot.pdf
  //Command 'P': cf p11
  //EEPROM parameters: cf p12
  //Ack check: cf p13
  command(0x50, config, 2, resp, 0, 0x80, 0x89); //Program EEPROM command is 0x50 ('P')
  while(!ready()) //Wait for a response
  {

  }

  if(!result()) //If this fails, there is something wrong with the hardware
  {
    return MIFARE_HW;
  }
  
  return MIFARE_OK;
}
  
RWDMifare::RWDMifareErr RWDMifare::getUID(uint8_t* pUID, size_t* pLen) //pUID must be at least 10-bytes long 
//(A Mifare UID can either be 4, 7, or 10 bytes long)
//This reader does not support 10 bytes uids
{
  //Cf http://www.ibtechnology.co.uk/pdf/MF_ICprot.pdf
  //Command 'U': cf p19
  //Ack check: cf p13
  command(0x55, NULL, 0, pUID, 7, 0x86, 0x86); //UID command is 0x55 ('U')
  while(!ready()) //Wait for a response
  {

  }
    
  if(!result()) //Error detected, there is no card in field
  {
    return MIFARE_NOCARD;
  }
  
  printf("Got card.\n");
    
  //Checks UID length returned by reader
  int i;
  for(i = 0; i < 7; i++)
  {
    if(pUID[i] == 0) //End of UID, cf http://www.ibtechnology.co.uk/pdf/MF_ICprot.pdf p19
      break;
  }
  *pLen = i;
  
  return MIFARE_OK;
}
