/*
Copyright (c) 2010 ARM Limited

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef TAGINFO_H
#define TAGINFO_H

#include "loginfo.h"

#include <ctime> //For time_t type

#include <string>
using std::string;

#include <time.h>

#include <stdint.h>
#include <string.h> //For size_t

/*
This class is a data container for each event's info (tag id, item location, timestamp).
It derives from LogInfo.
Some methods are available to format this data into CSVs and SQL instructions.
*/

class TagInfo : public LogInfo
{
public:
  TagInfo(const uint8_t* id, size_t idLen, int locationId, time_t timestamp);
  virtual ~TagInfo();

  virtual string toCSV() const;
  virtual string toSQL(const string& table) const;
  
private:
  char* m_idStr;
  int m_locationId;
  time_t m_timestamp;
};

#endif
