/*
Copyright (c) 2010 ARM Limited

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/*
This class provides beeping using different tones.
*/

#ifndef BEEP_H
#define BEEP_H

#include "mbed.h"

class Beep
{
public:
  Beep(PinName pin);
  ~Beep();
  
  enum BEEP_TONE
  {
    TONE_OK = 0,
    TONE_INFO,
    TONE_WARN,
    TONE_ERR
  };
  
  void beep(BEEP_TONE tone);

protected:
  void beepNote();
  void beepTick();
  void beepDone();
  
private:
  Ticker m_ticker;
  Timeout m_timeout;
  DigitalOut m_out;
  
//  float m_part[8]; //Len, freq, len, freq...
  float* m_part;
  int m_pos;
  
  static const float Tones[][8];

};

#endif
