/*
Copyright (c) 2010 ARM Limited

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "taginfo.h"
#include <stdio.h>

TagInfo::TagInfo(const uint8_t* id, size_t idLen, int locationId, time_t timestamp) : LogInfo(), m_locationId(locationId), m_timestamp(timestamp)
{
  m_idStr = new char[2*idLen+1]; //Each byte is coded on two chars, plus one 0-terminating char
  char* p = m_idStr; //Copy ID in a c-string format
  for(int i = 0; i < idLen; i++)
  {
    sprintf(p, "%02x", id[i]);
    p+=2;
  }
}

TagInfo::~TagInfo()
{
  delete[] m_idStr;
}

string TagInfo::toCSV() const
{
  char str[64] = {0};
  sprintf(str, "'%s',%d,%d", m_idStr, m_locationId, m_timestamp); //Format info into CSVs
  return string(str);
}

string TagInfo::toSQL(const string& table) const
{
  char cmd[128] = {0};
  char time_str[32] = {0};
  
  struct tm* timeinfo = localtime ( &m_timestamp );
  
  strftime(time_str, 32, "%Y-%m-%d %H:%M:%S", timeinfo);
    
  sprintf(cmd, "INSERT INTO %s (TagId, LastLocationId, Timestamp) VALUES('%s',%d,'%s')", table.c_str(), m_idStr, m_locationId, time_str); //Create SQL instruction to be executed by MySQL client

  return string(cmd);
}
