/*
Copyright (c) 2010 ARM Limited

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef LOGGER_H
#define LOGGER_H

#include "MySQLClient.h"

#include "queue.h"

#include <string>
using std::string;

#include "mbed.h"

#include "loginfo.h"

/*
The logger is responsible for writing data in the CSV file and queueing SQL requests and executing them on the SQL server using a MySQL client instance.
*/
class Logger
{
public:
  Logger(const string& table);
  ~Logger();
  
  //File Logging
  int fileOpen(const char* filename);
  int fileClose();
  
  //SQL Logging
  int sqlOpen(Host& host, const string& user, const string& password, const string& db);
  int sqlClose();
  
  //Log an event
  int log(LogInfo* pInfo); //Returns 0 on success, -1 on failure
  
  //Main service routine, must be called regularly
  void service();
  
  //Checks if requests queue is empty
  bool isEmpty();

  //Status info about SQL connection
  bool isConnecting();    
  bool isConnected();  
  bool connectionError();
  
  MySQLResult getLastResult();
  
protected:
  //Callback from MySQL client
  void onMySQLResult(MySQLResult r);

private:
  mbed::queue<string> m_lSQLReq;
  FILE* m_fd;
  
  string m_table;
  
 // Timer m_reqTimer;
  MySQLClient m_sqlClient;
  MySQLResult m_sqlLastResult;
  
  bool m_sqlConnecting;
  bool m_sqlConnected;
  bool m_sqlConnectionError;
  bool m_sqlCommand;

};

#endif
