/*

This is the main program for the RFID Tracking reference design.

-log/
-----logger.h
-----logger.cpp
The logger is responsible for writing data in the CSV file and queueing
SQL requests and executing them on the SQL server
using a MySQL client instance.

-----loginfo.h
This is a generic interface for a data container to be used with the
logger class.

-----taginfo.h
-----taginfo.cpp
This class is a data container for each event's info (tag id, item
location, timestamp).
It derives from LogInfo.
Some methods are available to format this data into CSVs and SQL
instructions.

-mifare/
--------RWDMifare.h
--------RWDMifare.cpp
This is a specific and quick implementation for the Mifare MicroRWD
modules.
The class configures the reader for Mifare operation and can poll for
UIDs

-ui/
----beep.h
----beep.cpp
This class provides beeping using different tones.

-Config_Common.h
Setup global parameters here:
- Log file
- NTP server
- SQL server

-main.cpp
This is the main file for this project.

** Ethernet-specific files **

This is the Ethernet version of the RFID Tracking reference design.

-Config_Impl.h
BB3-specific configuration.

-Ethernet.cpp
Initialization and closing routines for Ethernet interface, and program entry point.

** SD Card support **

-fs.cpp
Setup the SD Filesystem.

*/
