#include "mbed.h"
#include "EthernetNetIf.h"
#include "HttpClient.h"

EthernetNetIf eth; 

int main() {

  printf("Init\n");

  printf("\r\nSetting up...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("\r\nSetup OK\r\n");

  HttpClient twitter;
  
  HttpMap msg;
  msg["status"] = "I am tweeting from my mbed!"; //A good example of Key/Value pair use with Web APIs

  twitter.basicAuth("myuser", "mypass"); //We use basic authentication, replace with you account's parameters
  
  //No need to retieve data sent back by the server
  HttpResult r = twitter.post("http://twitter.com/statuses/update.xml", msg, NULL); 
  if( r == HTTP_OK )
  {
    printf("Tweet sent with success!\n");
  }
  else
  {
    printf("Problem during tweeting, return code %d\n", r);
  }
  
  return 0;

}
