#include "mbed.h"
#include "EthernetNetIf.h"
#include "HttpServer.h"

EthernetNetIf eth;  
HttpServer svr;

DigitalOut led1(LED1);

int main() {
  printf("\r\nSetting up...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("\r\nSetup OK\r\n");
  
  svr.addHandler<SimpleHandler>("/"); //Default handler
  svr.bind(80);
  
  printf("\r\nListening...\r\n");
    
  Timer tm;
  tm.start();
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(tm.read()>.5)
    {
      led1=!led1; //Show that we are alive
      tm.start();
    }
  }
  
  return 0;
}
