#include "mbed.h"
#include "EthernetNetIf.h"
#include "HttpServer.h"

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");

LocalFileSystem fs("webfs");

EthernetNetIf eth;  
HttpServer svr;

int main() {
  Base::add_rpc_class<DigitalOut>();

  printf("\r\nSetting up...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("\r\nSetup OK\r\n");
  
  svr.addHandler<SimpleHandler>("/hello");
  svr.addHandler<RpcHandler>("/rpc");
  svr.addHandler<FSHandler>(""); //Default handler
  //Example : Access to mbed.htm : http://a.b.c.d/webfs/mbed.htm
  
  svr.bind(80);
  
  printf("\r\nListening...\r\n");
    
  Timer tm;
  tm.start();
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(tm.read()>.5)
    {
      led1=!led1; //Show that we are alive
      tm.start();
    }
  }
  
  return 0;

}
