#include "mbed.h"
#include "EthernetNetIf.h"
#include "HttpClient.h"

EthernetNetIf eth; 
HttpClient http;

HttpResult result;
bool completed = false;
void request_callback(HttpResult r)
{
  result = r;
  completed = true;
}

int main() {

  printf("Start\n");

  printf("\r\nSetting up...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("\r\nSetup OK\r\n");
  
  HttpStream stream;
  
  char BigBuf[512 + 1] = {0};
  stream.readNext((byte*)BigBuf, 512); //Point to buffer for the first read
  
  HttpResult r = http.get("http://hackaday.com/feed/", &stream, request_callback); //Load a very large page, such as the hackaday RSS feed
  
  while(!completed)
  {
    Net::poll(); //Polls the Networking stack
    if(stream.readable())
    {
      BigBuf[stream.readLen()] = 0; //Transform this buffer is zero-terminated char* string
      printf("%s",BigBuf); //Displays it while loading
      //Note: some server do not like if you throttle them too much, so printf'ing during a request is generally bad practice
      stream.readNext((byte*)BigBuf, 512); //Buffer has been read, now we can put more data in it
    }
  }
  printf("\r\n--------------\r\n");
  if(result == HTTP_OK)
  {
    printf("Read completely\n"); 
  }
  else
  {
    printf("Error %d\n", result);
  }
  
  while(1)
  {
  
  }
  
  return 0;
  
}
