
/*
Copyright (c) 2010 Donatien Garnier (donatiengar [at] gmail [dot] com)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef UDPSOCKET_H
#define UDPSOCKET_H

#include "if/net/net.h"
//Essentially it is a safe interface to NetUdpSocket

enum UdpSocketErr
{
  __UDPSOCKET_MIN = -0xFFFF,
  UDPSOCKET_SETUP, //NetUdpSocket not properly configured
  UDPSOCKET_IF, //If has problems, does not exist or is not initialized
  UDPSOCKET_MEM, //Not enough mem
  UDPSOCKET_INUSE, //If/Port is in use
//...
  UDPSOCKET_OK = 0
};

enum UdpSocketEvent //Only one lonely event here... but who knows, maybe some day there'll be another one!
{
  UDPSOCKET_READABLE, //Data in buf
};


class UdpSocket
{
public:
  UdpSocket();
  ~UdpSocket(); //close()
  
  UdpSocketErr bind(const Host& me);
  
  int /*if < 0 : UdpSocketErr*/ sendto(const char* buf, int len, Host* pHost);
  int /*if < 0 : UdpSocketErr*/ recvfrom(char* buf, int len, Host* pHost);

  /* TODO NTH : printf / scanf helpers that call send/recv */

  UdpSocketErr close();

  class CDummy;
  //Callbacks
  void setOnEvent( void (*pMethod)(UdpSocketEvent) );
  template<class T> 
  //Linker bug : Must be defined here :(
  void setOnEvent( T* pItem, void (T::*pMethod)(UdpSocketEvent) )
  {
    m_pCbItem = (CDummy*) pItem;
    m_pCbMeth = (void (CDummy::*)(UdpSocketEvent)) pMethod;
  }
  
  void resetOnEvent(); //Disable callback

protected:
  void onNetUdpSocketEvent(NetUdpSocketEvent e);
  UdpSocketErr checkInst();

private:
  NetUdpSocket* m_pNetUdpSocket;
  
  CDummy* m_pCbItem;
  void (CDummy::*m_pCbMeth)(UdpSocketEvent);
  
  void (*m_pCb)(UdpSocketEvent);

};

#endif
