#include "mbed.h"
#include "EthernetNetIf.h"
#include "MySQLClient.h"

#define SQL_SERVER   ""
#define SQL_USER     ""
#define SQL_PASSWORD ""
#define SQL_DB       ""

EthernetNetIf eth; 
MySQLClient sql;

MySQLResult sqlLastResult;
void onMySQLResult(MySQLResult r)
{
  sqlLastResult = r;
}

int main()
{
  printf("Start\n");

  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
  Host host(IpAddr(), 3306, SQL_SERVER);
  
  //Connect
  sqlLastResult = sql.open(host, SQL_USER, SQL_PASSWORD, SQL_DB, onMySQLResult);
  while(sqlLastResult == MYSQL_PROCESSING)
  {
    Net::poll();
  }
  if(sqlLastResult != MYSQL_OK)
  {
    printf("Error %d during connection\n", sqlLastResult);
  }
  
  //SQL Command
  //Make command
  char cmd[128] = {0};
  const char* msg="Hello World!";
  sprintf(cmd, "INSERT INTO Test (Test) VALUES('%s')", msg);
  
  //INSERT INTO DB
  string cmdStr = string(cmd); 
  sqlLastResult = sql.sql(cmdStr);
  while(sqlLastResult == MYSQL_PROCESSING)
  {
    Net::poll();
  }
  if(sqlLastResult != MYSQL_OK)
  {
    printf("Error %d during SQL Command\n", sqlLastResult);
  }
  
  sql.exit();
  
  while(1)
  {
  
  }
  
  return 0;
}