#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

EthernetNetIf eth; 
HTTPClient http;

HTTPResult result;
bool completed = false;
void request_callback(HTTPResult r)
{
  result = r;
  completed = true;
}

int main() {

  printf("Start\n");

  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
  HTTPStream stream;
  
  char BigBuf[512 + 1] = {0};
  stream.readNext((byte*)BigBuf, 512); //Point to buffer for the first read
  //HTTPResult r = http.get("http://newsrss.bbc.co.uk/rss/newsonline_uk_edition/front_page/rss.xml", &stream, request_callback); //Load a very large page, such as the hackaday RSS feed
  //HTTPResult r = http.get("http://hackaday.com/feed/", &stream, request_callback); //Load a very large page, such as the hackaday RSS feed
  HTTPResult r = http.get("http://mbed.org/blog/feeds/entries/", &stream, request_callback); //Load a very large page
  
  while(!completed)
  {
    Net::poll(); //Polls the Networking stack
    if(stream.readable())
    {
      BigBuf[stream.readLen()] = 0; //Transform this buffer in a zero-terminated char* string
      printf("%s",BigBuf); //Display it while loading
      //Note: some servers do not like if you throttle them too much, so printf'ing during a request is generally bad practice
      stream.readNext((byte*)BigBuf, 512); //Buffer has been read, now we can put more data in it
    }
  }
  printf("\n--------------\n");
  if(result == HTTP_OK)
  {
    printf("Read completely\n"); 
  }
  else
  {
    printf("Error %d\n", result);
  }
  
  while(1)
  {
  
  }
  
  return 0;
  
}
