#include "mbed.h"

#include "EthernetNetIf.h"

#include "SDHCFileSystem.h"

#include "HTTPClient.h"

SDFileSystem sd(p5, p6, p7, p8, "sd"); //p9: SD present; p8: CS

EthernetNetIf eth;
HTTPClient http;

int main() {

  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
  {

    HTTPFile f("/sd/m.pdf");
  
    HTTPResult r = http.get("http://mbed.org/media/press/mbed_whitepaper.pdf", &f);

    if(r==HTTP_OK)
    {
      printf("Result OK\n"); 
    }
    else
    {
      printf("Error %d\n", r);
    }
  }  
  while(1)
  {
  
  }
  
  return 0;
  
}
