/* EthernetNetwork.h */
/*
Copyright (C) 2012 ARM Limited.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#ifndef ETHERNETNETWORK_H_
#define ETHERNETNETWORK_H_


#include "core/fwk.h"

#include "rtos.h"

#include "LwIPInterface.h"

#include "lwip/netif.h"

/** Interface using Ethernet to connect to an IP-based network
 *
 */
class EthernetNetwork : public LwIPInterface
{
public:
  EthernetNetwork();

  int init(); //With DHCP

  int init(const char* ip, const char* mask, const char* gateway, const char* dns1, const char* dns2); //No DHCP

  virtual int connect();
  virtual int disconnect();

private:
  static void phySupervisorCb(void const* ctx);

  RtosTimer m_supervisor;
  struct netif m_lpcNetif;
  bool m_useDHCP;
  bool m_linkUp;
};

#endif /* ETHERNETNETWORK_H_ */
