/* lwipopts.h */
/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef LWIPOPTS_H_
#define LWIPOPTS_H_
 
#include "lwipopts_common.h" //Get common options

#define MEM_SIZE 16362 //Needs a huge buffer pool

#define LWIP_ARP 1 //Enable ARP

/* This define is custom for the LPC EMAC driver. Enabled it to
 get debug messages for the driver. */
#define UDP_LPC_EMAC                    LWIP_DBG_OFF

/* No padding needed */
#define ETH_PAD_SIZE                    0

/* MSS should match the hardware packet size */
#define TCP_MSS                        1460
#define TCP_SND_BUF           (2 * TCP_MSS)
#define TCP_WND               (2 * TCP_MSS)
#define TCP_SND_QUEUELEN      (2 * TCP_SND_BUF/TCP_MSS)

#define IP_SOF_BROADCAST        1
#define IP_SOF_BROADCAST_RECV     1

/* The ethernet FCS is performed in hardware. The IP, TCP, and UDP
 CRCs still need to be done in hardware. */
#define CHECKSUM_GEN_IP                 1
#define CHECKSUM_GEN_UDP                1
#define CHECKSUM_GEN_TCP                1
#define CHECKSUM_CHECK_IP               1
#define CHECKSUM_CHECK_UDP              1
#define CHECKSUM_CHECK_TCP              1
#define LWIP_CHECKSUM_ON_COPY           1

/* DHCP is ok, UDP is required with DHCP */
#define LWIP_DHCP                       1
#define LWIP_UDP                        1

/* Hostname can be used */
#define LWIP_NETIF_HOSTNAME             1

#define LWIP_BROADCAST_PING       1

#define LWIP_NETIF_STATUS_CALLBACK 1 //We want to be notified whenever the netif state changes 


#endif /* LWIPOPTS_H_ */