/* net_3g_basic_http_test.cpp */
/*
Copyright (C) 2012 ARM Limited.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#define __DEBUG__ 4 //Maximum verbosity
#ifndef __MODULE__
#define __MODULE__ "net_eth_basic_http_test.cpp"
#endif

#include "core/fwk.h"
#include "mbed.h"

#include "rtos.h"

#include "if/EthernetNetwork.h"
#include "HTTPClient.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
void notify(bool a, bool b, bool c)
{
  led1 = a;
  led2 = b;
  led3 = c;
}

extern "C" void HardFault_Handler()
{
  error("Hard Fault!\n");
}

void test(void const*)
{
  EthernetNetwork eth;
  HTTPClient http;
  char str[512];

  DBG("Hello!");
  
  int count = 0;
  eth.init(); //Use DHCP

  start:
  count++;
  DBG("iteration #%d", count);

  notify(0, 1, 1);
  int ret = eth.connect();
  notify(0, 1, 0);
  if (ret == OK)
  {
    DBG("Trying to fetch page...");
    ret = http.get("http://mbed.org/media/uploads/donatien/hello.txt", str, 128);
    if (ret == OK)
    {
      DBG("Page fetched successfully - read %d characters", strlen(str));
      DBG("Result: %s", str);
    }
    else
    {
      WARN("Error - ret = %d - HTTP return code = %d", ret, http.getHTTPResponseCode());
    }

    HTTPMap map;
    HTTPText text(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    DBG("Trying to post data...");
    ret = http.post("http://httpbin.org/post", map, &text);
    if (ret == OK)
    {
      DBG("Executed POST successfully - read %d characters", strlen(str));
      DBG("Result: %s", str);
    }
    else
    {
      WARN("Error - ret = %d - HTTP return code = %d", ret, http.getHTTPResponseCode());
    }
  }
  eth.disconnect();
  DBG("Disconnected");

  notify(1, 1, 1);

  goto start;

  while (1)
  {
    Thread::wait(100);
  }
}

void keepAlive(void const*)
{
  while (1)
  {
    led1 = !led1;
    Thread::wait(500);
  }
}

void tick()
{
  led4 = !led4;
}

int main()
{
  Ticker t;
  t.attach(tick, 1);
  DBG_INIT();
  notify(1, 0, 0);

  Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
  keepAlive(NULL);

  return 0;
}
