/**
@file joystick.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Joystick header file, with modification from original file
@brief CHANGEME_H_ and endif added to prevent header file error https://developer.mbed.org/cookbook/Compiler-Error-256
@brief Original code https://developer.mbed.org/users/eencae/code/Joystick/
@author Craig A. Evans (Original author)
@author Dominic J. Platt (Modifications labelled)
@date   April 2015
*/
#ifndef CHANGEME_H_
#define CHANGEME_H_
#include "mbed.h"

#define DIRECTION_TOLERANCE 0.05

/**
@namespace joystickButton
@brief joystick button output when user presses joystick
*/
extern InterruptIn joystickButton;

/**
@namespace serial
@brief serial used for code debug checking with coolterm software
*/
extern Serial serial;

/**
@namespace pollJoystick
@brief Ticker type variable to set how often the joystick is read
*/
extern Ticker pollJoystick;

typedef struct JoyStick Joystick;

/**
Used to define to hold the properties of our joystick
*/
struct JoyStick {
    /**
    * the x coordinate */
    float x;
    //! 'centred' x value
    float x0;
    //! current y value
    /*!
      read from y direction potentiometer
    */
    float y;
    //! 'centred' y value
    float y0;
    //! button state
    /*!
      (assume pull-down used, so 1 = pressed, 0 = unpressed)
    */
    int button; // button state
    //! direction in two dimensions
    /*!
      values of 1,0,-1 for each element
      e.g. the matrix of {-1,0} will mean direction is -1 in x directions and 0 in the y direction
      property added by Dominic Platt
    */
    int direction[2];  // current direction x,y used
    /*@}*/
};
/**
@brief create joystick instance
*/
extern Joystick joystick;

/**
@brief calibrating joystick, joystick must not move during this
*/
void calibrateJoystick();
/**
@brief read current joystick values relative to calibrated values
*/
void updateJoystick();
//! printFlag used to print the joystick directions for bebugging
extern int printFlag;
 
#endif