/**
@file joystick.cpp
 
@brief Program implementation
@brief Original code https://developer.mbed.org/users/eencae/code/Joystick/ 
*/
#include "mbed.h"
#include "joystick.h"
InterruptIn joystickButton(p17);
AnalogIn xPot(p16);
AnalogIn yPot(p15);
Ticker pollJoystick;
Serial serial(USBTX,USBRX);
int printFlag = 0;
Joystick joystick;

void calibrateJoystick()
{
    joystickButton.mode(PullDown);
    // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}

void updateJoystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = xPot - joystick.x0;
    joystick.y = yPot - joystick.y0;
    // read button state
    joystick.button = joystickButton;

    // calculate direction depending on x,y values
    // tolerance allows a little lee-way in case joystick not exactly in the stated direction
    //Direction matrix modified here depending on the direction tolerence
    // +1 is down/right, 0 is centre and -1 is up/left
    //modified by Dominic Platt
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction[0] = 0; //middle for y
    } else if ( joystick.y > DIRECTION_TOLERANCE) {
        joystick.direction[0] = 1; //up
    } else if ( joystick.y < DIRECTION_TOLERANCE) {
        joystick.direction[0] = -1; // down
    }
    if (fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction[1] = 0; // centre for x
        }
    else if ( joystick.x > DIRECTION_TOLERANCE) {
        joystick.direction[1] = 1; // right
    } else if ( joystick.x < DIRECTION_TOLERANCE) {
        joystick.direction[1] = -1; //left
    } else {
        joystick.direction[0] = 0;
        joystick.direction[1] = 0;
    }

    // set flag for printing
    printFlag = 1;
}