#include "Operator.h"

Operator::Operator()
{
    srand(time(NULL)); //seed random number so the sequence is not the same each run through.
    _num_players=0;

}

Operator::~Operator()
{

}


bool Operator::test_player(int next_player, Controller &ctrl, Display &display, N5110 &lcd)
{

    ctrl.ledsOFF();
    int instruction_val = random_instruction(display, lcd);     //sets instruction_val as the random instruction from display
    //printf("OPP:test_player instruction_val = %d\n", instruction_val);
    display.drawCircle(ctrl, lcd);                                    //Draws circle, displays instruction and allows the circle to be drawn faster with time
    int button_val = ctrl.check_for_buttons();                       //sets button_val as the instruction performed by the user
    //printf("OPP:test_player button_val = %d\n", button_val);


    if (button_val == instruction_val) {         //if the user performs the instruction correctly return true

        return true;
    } else {                                    //otherwise the user has performed the instruction incorrectly return false
        return false;
    }                                              
}

int Operator::random_instruction(Display &display, N5110 &lcd)
{

    int ran = rand() % 7 + 1;                   //generates random numbers between 0 and 8.
    //printf("OPP ran = %d\n", ran);
    display.display_instruction(lcd, ran);
    return ran;
}

void Operator::correct(int current_player, Controller &ctrl)
{
    myplayers[current_player]._score++;                                                //increment score for player
    _score = myplayers[current_player]._score;
    double _freqChange = _score*20;
    //printf("OPP score = %d\n", score);
    ctrl.led(1,1);
    ctrl.led(2,1);
    ctrl.led(3,1);
    ctrl.sound(50.0 + _freqChange,0.2);                                             //update speed of reaction
}

void Operator::inCorrect(int current_player, Controller &ctrl)
{
    //printf("OPP.Incorrect player = %d\n", next_player);
    ctrl.sound(200,1);
    myplayers[current_player].status = false;                                          //set player to dead (false)
}

bool Operator::both_dead()
{
    //printf("OPP.both_dead P1 %d\n", myplayers[0].status);
    //printf("OPP.both_dead P2 %d\n", myplayers[1].status);
    
    if (!myplayers[0].status && !myplayers[1].status) {                         // if both players false then both dead = true
        return true;
    } else {
        return false;
    }

}



int Operator::check_next_player(int current_player, N5110 &lcd, Controller &ctrl, Display display)
{

    int mynext_player = current_player;
    //printf("OPP.check_next_player(1) current_player %d\n", mynext_player);
    if (_num_players > 1) {

        if ( (myplayers[current_player]._score % 10 == 0) || (!myplayers[current_player].status)) {  //on 0, and multiples of 10 swap player unless other player is dead
            myplayers[current_player].wait = display.get_wait();      //save speed
            
            if (current_player == 0 && myplayers[1].status) {                             //change to next player
                mynext_player = 1;
            }

            if (current_player == 1 && myplayers[0].status) {                             //change to next player
                mynext_player = 0;
            }
            //printf("OPP.check_next_player(2) next_player %d\n", mynext_player);
            display.put_wait(myplayers[mynext_player].wait);                            //put speed
            _displayNextPlayer(ctrl,lcd,mynext_player);                                  //Display next player
        }

    }
    return mynext_player;
}

void Operator::_displayNextPlayer(Controller &ctrl, N5110 &lcd, int thenext_player)
{ 
//Screen telling user to swap players
    printf("OPP.DisplayNextPlayer threnext_player %d\n", thenext_player); 
    char buff[14];
    lcd.clear();
    sprintf(buff,"Player %d ",thenext_player+1);
    lcd.printString(buff,20,2);
    lcd.refresh();
    lcd.printString("3",40,4);
    ctrl.sound(50,1);
    lcd.refresh();
    wait(1);
    lcd.printString("2",40,4);
    lcd.refresh();
    ctrl.sound(200,1);
    wait(1);
    lcd.printString("1",40,4);
    lcd.refresh();
    ctrl.sound(300,1);
    wait(1);
    lcd.printString("0",40,4);
    lcd.refresh();
    ctrl.sound(400,2);
    wait(2);
}


void Operator::setup_players(int num_of_players)
{

    myplayers[0].wait = 0.3;
    myplayers[0].status = true;
    myplayers[0]._score = 0;
    myplayers[1]._score = 0; 
    myplayers[1].wait = 0.3;

    if (num_of_players == 1) {
        myplayers[1].status = false;
    } else {
        myplayers[1].status = true;
    }
    _num_players = num_of_players;
}



void Operator::gameOver(Controller &ctrl, N5110 &lcd)
{
    ctrl.init();                                            //reset flags

    while(ctrl.check_event(Controller::BACK_PRESSED) == false) {
        if (_num_players == 1) {
            _assessment(lcd, myplayers[0]._score);                //Display results for single player
            //printf("OPP num of Players = %d\n", _num_players);
        } else {
            _multiResults(lcd);                                 //display results for multiplayer
        }
        ctrl.ledsOFF();
        ctrl.led(4,1);
        ctrl.led(5,1);
        ctrl.led(6,1);
    }

    setup_players(1);
    _score = 0;
}

void Operator::_assessment(N5110 &lcd, int _score) 
{ 
//Awarding the user a level based on score achieved
    //printf("OPP.ASSESSMENT score = %d\n", _score);
    lcd.printString("Game Over",16,0);
    char buffer[14];
    if (_score < 10) {
        sprintf(buffer,"0%d",_score);
        lcd.printString("Newbie",26,4);
    } else if (_score < 20) {
        sprintf(buffer,"%2d",_score);
        lcd.printString("Amuteur",24,4);
    } else if (_score < 30) {
        sprintf(buffer,"%2d",_score);
        lcd.printString("Expert",26,4);
    } else if (_score < 40) {
        sprintf(buffer,"%2d",_score);
        lcd.printString("Professional",10,4);
    } else if (_score < 50) {
        sprintf(buffer,"%2d",_score);
        lcd.printString("World Class",14,4);
    } else {
        sprintf(buffer,"%2d",_score); 
        lcd.printString("Legendary",16,4);
        
    }
    lcd.printString(buffer,37,2);
    lcd.drawCircle(42,20,10,FILL_TRANSPARENT); 
    lcd.refresh();
}


void Operator::_multiResults(N5110 &lcd)
{ 
//Displaying scores
    //printf("OPP.MULTIRESULTS\n");
    lcd.clear();
    lcd.printString("Game Over",16,0);
    char buffer[14];
    sprintf(buffer,"Player 1 - %d",myplayers[0]._score);
    lcd.printString(buffer,5,2);
    sprintf(buffer,"Player 2 - %d",myplayers[1]._score);
    lcd.printString(buffer,5,3);
    int score1 = myplayers[0]._score;   
    int score2 = myplayers[1]._score;   

//Identifying the winner
    if (score1 > score2) { 
        lcd.printString("Player 1 Wins", 5,4);
    } else {
        if (score2 > score1) {
            lcd.printString("Player 2 Wins", 5,4);
        } else {
            lcd.printString("Draw",5,4);
        }
    }

    lcd.refresh();
}