#ifndef OPERATOR_H
#define OPERATOR_H

#include "mbed.h"
#include "N5110.h"
#include "Display.h" 
#include "Controller.h"  
/** Player Struct
@brief This Struct stores:- whether the previous player has already lost the game or not, how much time they intially had to
perform an instruction and the score they have. This struct is crucial for multiplayer.
@author Dominic Kay

@date April 2017
*/


struct Player {
    float wait;  /**< float for wait time */
    bool status; /**< true/flase alive or dead */
    int _score; /**< score */
};

/** Operator Class
@brief This class is the engine of the program. It encapsulates all the methods to do with managing scores, commands and player states(dead/alive). 

@author Dominic Kay

@date April 2017
*/


class Operator
{

public: 
    
    /**Contructor*/
    Operator();
    
    /**Destructor*/
    ~Operator();


 /**
     * @brief generates a random integer to be used in the display class to represent an instruction
     * @param Display, N5110
     * @return random integer
     */
    int random_instruction(Display &display, N5110 &lcd);  

/** 
    *  @brief Method to test the player 
    *  @param the player to test, Controller, Display, N5110
    *  @return true/false on Success
    */
    bool test_player(int nextplayer, Controller &ctrl, Display &display, N5110 &lcd);

/** 
    *  @brief Method to check if both players are dead 
    *  @return true/false
    */
    bool both_dead();

/** Method performed when the user performs the RIGHT instruction on time, score is increased, lighting and sound performed.
    *  @param the player, Controller
    */
    void correct(int current_player, Controller &ctrl);  

/** Method performed when the user performs the WRONG instruction on time 
    *  @param the player, Controller
    */
    void inCorrect(int current_player, Controller &ctrl);  

/** Method to set up array of Player strut 
    *  @param the number of players to set up
    */
    void setup_players(int num_players);
            
/** Method performed when the user is too slow or performs the wrong instruction, score is displayed, game ends 
    *  @param the player, Controller
    */
    void gameOver(Controller &ctrl, N5110 &lcd);
    
/** Method performed to check which user it is and to swap after every ten actions*/
    int check_next_player(int current_player, N5110 &lcd, Controller &ctrl, Display display);

private:  
    /** This method displays and assesses score and display a performace rating for user to see.
    *  @param N5110, score
    */    
    void _assessment(N5110 &lcd, int score); 
 
    /** This method displays and assesses scores when multi-player
    *  @param N5110
    */
   void _multiResults(N5110 &lcd);
  
    /** This method counts down the next player 
    *  @param Controller, N5110, the player to display next turn
    */ 
   void _displayNextPlayer(Controller &ctrl, N5110 &lcd, int thenext_player);
   
       
    float _freqChange;
    int _score; // <score to indentify users progress through game
    Player myplayers[1]; //setup players 
    int _num_players;    //set num_players
    
};

#endif