#ifndef DISPLAY_H
#define DISPLAY_H

#include "mbed.h"
#include "N5110.h" 
#include "Controller.h"

/** Display Class
@brief This class encapsulates all the algorithms required for the displaying strings and time dependant patterns on the lcd.
@author Dominic Kay

@date April 2017
*/
class Display
{

public:
   
   /** Constructor */
    Display(); 
    
    /** Destructor */
    ~Display();
    
    /** Sets all variables to zero and resets wait time to max value */
    void init();
    
    /** Method for drawing the circle and decreasing the wait time */
    void drawCircle(Controller &ctrl, N5110 &lcd); 
    
    
    /**
     * @brief Method for resetting the wait time if multi-player 
     * @param class variable w
     * @return void
     */  
    void put_wait(float w); 
    
    /**
     * @brief Method for getting the wait time if multi-player 
     * @return wait time
     */ 
    float get_wait(); 
    
    /**
     * @brief Displays a random instruction for the user to perform 
     * @param ran (random number generated from operator)
     * @return void
     */
    void display_instruction(N5110 &lcd, int ran);   

     
private:
      
     /** Methord for the mathematical operation behind the change in time before gameover */
    void _calculateWait();
    
    /** 
    @brief Method allowing one octant to be displayed at one time. Also allows interaction with controller for flashing screen and sounds 
    @param id[in] void
    @return interger used in for loop (representing number of loops) 
    */
    void _arc_selector(Controller &ctrl, N5110 &lcd); 
    
    /**
     * @brief An algorithm that draws the eight octants of a circle pixel by pixel.
     * @param id[in] interger used in for loop from Circle() Methord
     * @return void
     */
    void _drawArc(N5110 &lcd, int a); 
    
    int _h;             // <<score / number of full circle performed      
    float _w;           // <<wait time 
    int _a;             // <<for loop variable 
    int _x;              // <<radius of circle
    int _y;              // <<y co-ordinate 
    int _x0;             // <<variable used to modify x
    int _y0;             // <<variable used to modify y
    int _radiusMod;      // <<1 - the radius of the circle
    

};
#endif