#include "Display.h"
#include "N5110.h"
#include "Controller.h"
#include <math.h>

Display::Display()
{
     _h = 0;
     _w = 0.2;
     _a = 0; 
     _x = 0;
    _y = 0; 
    _x0 = 0;
    _y0 = 0;
}

Display::~Display()
{

}
void Display::init()
{

     _h = 0;
     _w = 0.2;
     _a = 0;
     _x = 0; 
     _y = 0; 
     _x0 = 0;
    _y0 = 0; 
}

void Display::drawCircle(Controller &pad, N5110 &lcd)
{  
    _arc_selector(pad, lcd);  
    //printf("Prev Wait:- %3.2f\n",_w);
    _calculateWait();  
    _h++;  
    //printf("Score:- %d\n",_h);
    lcd.clear(); 
    lcd.refresh();
    } 

void Display::_calculateWait() 
{  
   _w = 0.2*exp(-0.0231*_h);  //this equation models how much time the user has 
                            //to complete action with larger amounts of iterations. 
} 


void Display::put_wait(float w) 
{  
   _w = w;
    
} 

float Display::get_wait() 
{  
   return _w;
    
} 
   
void Display::display_instruction(N5110 &lcd, int ran) {   //printing a random instruction on the screen
    lcd.clear();
    if (ran == 1){
        lcd.printString("PRESS",28,2);
        lcd.printChar('A',40,3); } 
    else if (ran == 2){ 
        lcd.printString("PRESS",28,2);
        lcd.printChar('B',40,3); }  
    else if (ran == 3){ 
        lcd.printString("PRESS",28,2);
        lcd.printChar('X',40,3); }  
    else if (ran == 4){ 
        lcd.printString("PRESS",28,2);
        lcd.printChar('Y',40,3); } 
    else if (ran == 5){ 
        lcd.printString("FLICK",28,2);
        lcd.printChar('L',40,3); }  
    else if (ran == 6){ 
        lcd.printString("FLICK",28,2);
        lcd.printChar('R',40,3); }     
    else {
        lcd.printString("PRESS",28,2);
        lcd.printString("STICK",28,3); }  
    //printf("Random Instruction int:- %d\n", ran);
    lcd.refresh(); 
    } 
       
// function to draw circle
void Display::_arc_selector(Controller &ctrl ,N5110 &lcd)
{
  for (int _a = 0; _a < 8; ++_a)
        {
    //printf("for loop (a):- %d\n",a);
    _drawArc(lcd, _a); //run through _drawArc function drawing octant specific to a value
    lcd.refresh();
    float Brightness = ctrl.pot_value(); //set brightness to petentiometer value
    lcd.setBrightness(0.0);         
    //printf("Brightness:- %3.2f\n",Brightness);
    //printf("Wait used:- %3.2f\n",_w);
    wait(_w); 
    lcd.setBrightness(Brightness); //Variable brightness will change with petentiometer value
    wait(_w); //changes after every circle is drawn to make the game more exciting.
         }
 
   }   
    
void Display::_drawArc(N5110 &lcd, int _a) { 
    _x = 20;
    _y = 0;
    
    int a1;
    int b1;
    _radiusMod = 1-_x; 
    _x0 = 42; 
    _y0 = 24;

//the algorithm below is a modified version of the midpoint circle algorithm from: 
//https://en.wikipedia.org/wiki/Midpoint_circle_algorithm    
    
    while(_x >= _y) { 
    
    switch(_a) { 
    
        case 0 : {a1 = _y;           //each case statement draws a single octant by setting a1 and b1 accordingly
                  b1 = _x * -1;
                  break;
                }            
        case 1 : {a1 = _x;
                  b1 = _y * -1;
                  break;
                }           
        case 2 : {a1 = _x;
                  b1 = _y;
                  break;
                }                       
        case 3 : {a1 = _y;
                  b1 = _x;
                  break;
                }   
        case 4 : {a1 = _y * -1;
                  b1 = _x;
                  break;
                } 
        case 5 : {a1 = _x * -1;
                  b1 = _y;
                  break;
                }
        case 6 : {a1 = _x * -1;
                  b1 = _y * -1;
                  break;
                }                
        case 7 : {a1 = _y * -1;
                  b1 = _x * -1;
                  break;
                }               
        default : { a1 = _x;
                b1 = _y * -1;
                break;
                } 
        }
                                  
                              
            lcd.setPixel( a1 + _x0,  b1 + _y0); //draws octant depending on a1 and b1
        
        _y++;   

   
        if (_radiusMod<0) {
            _radiusMod += 2*_y+1;
        } else {
            _x--;
            _radiusMod += 2*(_y-_x)+1;
        }
        //printf("_a1:- %d\n", _a1); 
        //printf("_b1:- %d\n", _b1); 
        //printf("_x:- %d\n", _x); 
        //printf("_y:- %d\n", _y);
        //printf("_radiusMod:- %d\n",_radiusMod);
    }
}