#include "mbed.h"
#include "N5110.h"
#include "Display.h"
#include "Controller.h"
#include "Operator.h"

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Display display;
Controller ctrl;
Operator Opp;

int num_players;
int instruction_val;
int current_player;
bool multi_player;
void starter();

/** Polar coordinate struct */


int main()
{

    lcd.init();         //the lcd and controller are configured and set to their default states
    display.init();     //
    ctrl.init();       //

    starter();           //Method describing starting screen when the controller is first booted up

    while(1) {
        current_player = Opp.check_next_player(current_player, lcd, ctrl, display);   // find the current player after 10 goes or failure
        if (Opp.test_player(current_player, ctrl, display, lcd)) {                 //current player returns true or flase depending on success
            Opp.correct(current_player, ctrl);                                     //process correct response
        } else {
            Opp.inCorrect(current_player, ctrl);                                   // process incorrect response
            
            if (!multi_player || (multi_player && Opp.both_dead())  )   {      //game over called if single player or multiplayer and both players are dead
                Opp.gameOver(ctrl, lcd);                                          //display score and level
                display.init();                                                 //reset waiting time
                starter();
            }                                                                //go back to starter screen
        }
    }


}

void starter()
{

    num_players = 1;


    lcd.clear();
    lcd.printString("Quick Click",10,0);

    lcd.refresh();
    while (ctrl.check_event(Controller::JOY_PRESSED) == false) {        // set single or multiplayer


        float flicked = ctrl.get_joy();                                 // pressing Joystick completes selection
        if (flicked > 1) {                                              // flicking Joystick left or right selects no of players
            num_players--;
        }
        if (flicked < -0.5) {
            num_players++;
        }
        if (num_players < 1) {                                               // lowest value is 1
            num_players = 1;
        }
        if (num_players > 2) {                                               // highest value is 2
            num_players = 2;
        }

        if (num_players == 1) {
            lcd.printString("<Single>Player",0,2); // display message
            multi_player = false;
            current_player = 0;

        } else {
            lcd.printString("<Multi >Player",0,2); // display message
            multi_player = true;
            current_player = 1;
        }
        
        Opp.setup_players(num_players);
        lcd.printString("<JOYSTICK>",10,5);
        lcd.refresh();
        wait(0.2);
    }

    lcd.clear();
    lcd.printString("Quick Click",10,0);                                 //text to be displayed when on starter screen
    lcd.printString("Start >",24,5);
    lcd.refresh();



    while (ctrl.check_event(Controller::START_PRESSED) == false) {       //keep flashing the leds and perform no other action until start is pressed
        ctrl.ledsON();
        wait(0.1);
        ctrl.ledsOFF();
        wait(0.1);
    }
}
