#include "Led_Lcd.h"
Led_Lcd::Led_Lcd(unsigned char ucColumn) {
    ucColumnXPos = ((ucColumn - 1) * 80);
    lcd.Clear(LCD_COLOR_BLACK);
}
void Led_Lcd::On(unsigned char ucVersion) {
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillRect(ucColumnXPos, 0, 80, 80);
    lcd.FillRect(ucColumnXPos, 80, 80, 80);
    lcd.FillRect(ucColumnXPos, 160, 80, 80);
    lcd.FillRect(ucColumnXPos, 240, 80, 80);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    switch(ucVersion) {
        case 0:
            lcd.FillRect(ucColumnXPos, 0, 80, 80);
            break;
        case 1:
            lcd.FillRect(ucColumnXPos, 80, 80, 80);
            break;
        case 2:
            lcd.FillRect(ucColumnXPos, 160, 80, 80);
            break;
        case 3:
            lcd.FillRect(ucColumnXPos, 240, 80, 80);
            break;
        default:
            break;
    }
    lcd.FillRect(ucColumnXPos, 0, 1, 320);
    lcd.FillRect((79 + ucColumnXPos), 0, 1, 320);
    lcd.FillRect(ucColumnXPos, 0, 80, 1);
    lcd.FillRect(ucColumnXPos, 79, 80, 1);
    lcd.FillRect(ucColumnXPos, 159, 80, 1);
    lcd.FillRect(ucColumnXPos, 239, 80, 1);
    lcd.FillRect(ucColumnXPos, 319, 80, 1);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetFont(&Font24);
    lcd.DisplayStringAt(ucColumnXPos, 0, (uint8_t *)"0", LEFT_MODE);
    lcd.DisplayStringAt(ucColumnXPos, 79, (uint8_t *)"1", LEFT_MODE);
    lcd.DisplayStringAt(ucColumnXPos, 159, (uint8_t *)"2", LEFT_MODE);
    lcd.DisplayStringAt(ucColumnXPos, 239, (uint8_t *)"3", LEFT_MODE);
};