#include "Keyboard_Ts.h"

Keyboard_Ts::Keyboard_Ts(unsigned char ucColumn) {
    ts.Init(lcd.GetXSize(), lcd.GetYSize());
    ucColumnXPos = ((ucColumn - 1) * 80);
}

enum Read Keyboard_Ts::eRead() {
    ts.GetState(&TS_State);
    if (TS_State.TouchDetected) {
        x = TS_State.X;
        y = TS_State.Y;
        if(x <= (80 + ucColumnXPos) && x >= ucColumnXPos) {
            if(y <= 79) {
                return BUTTON_0;
            }
            else if(y >= 80 & y <= 159) {
                return BUTTON_1;
            }
            else if(y >= 160 & y <= 239) {
                return BUTTON_2;
            }
            else if(y >= 240) {
                return BUTTON_3;
            }
        }
    }
return NO_BUTTON;
}