// SegDisplay.cpp file for Exercise 7-7
#include "SegDisplay.h"
BusOut Seg1(PC_0, PC_1, PB_0, PA_4, PF_1, PC_3, PC_2, PC_14); // A,B,C,D,E,F,G,DP
BusOut Seg2(D6, D7, D8, D9, D10, D11, D12, D14); // A,B,C,D,E,F,G,DP
BusOut Seg3(PB_13, PB_14, PB_15, PB_1, PB_2, PB_11, PB_12, PA_11);
void SegInit(void)
{
    Seg1=SegConvert(0); // initialise to zero
    Seg2=SegConvert(0); // initialise to zero
    Seg3=SegConvert(0); // initialise to zero
}
char SegConvert(char SegValue)   // function 'SegConvert'
{
    char SegByte = 0x00;
    switch (SegValue) { // DP G F E D C B A
        case 0:
            SegByte = 0x3F;
            break; // 0 0 1 1 1 1 1 1 binary
        case 1:
            SegByte = 0x06;
            break; // 0 0 0 0 0 1 1 0 binary
        case 2:
            SegByte = 0x5B;
            break; // 0 1 0 1 1 0 1 1 binary
        case 3:
            SegByte = 0x4F;
            break; // 0 1 0 0 1 1 1 1 binary
        case 4:
            SegByte = 0x66;
            break; // 0 1 1 0 0 1 1 0 binary
        case 5:
            SegByte = 0x6D;
            break; // 0 1 1 0 1 1 0 1 binary
        case 6:
            SegByte = 0x7D;
            break; // 0 1 1 1 1 1 0 1 binary
        case 7:
            SegByte = 0x07;
            break; // 0 0 0 0 0 1 1 1 binary
        case 8:
            SegByte = 0x7F;
            break; // 0 1 1 1 1 1 1 1 binary
        case 9:
            SegByte = 0x6F;
            break; // 0 1 1 0 1 1 1 1 binary
        case 10:
            SegByte = 0x00;
            break; // 0 0 0 0 0 0 0 0 binary
    }
    return SegByte;
}

char SegConvertDot(char SegValue)   // function 'SegConvertDot'
{
    char SegByte = 0x00;
    switch (SegValue) { // DP G F E D C B A
        case 0:
            SegByte = 0xBF;
            break; 
        case 1:
            SegByte = 0x86;
            break; 
        case 2:
            SegByte = 0xDB;
            break; 
        case 3:
            SegByte = 0xCF;
            break; 
        case 4:
            SegByte = 0xE6;
            break; 
        case 5:
            SegByte = 0xED;
            break; 
        case 6:
            SegByte = 0xFD;
            break; 
        case 7:
            SegByte = 0x87;
            break; 
        case 8:
            SegByte = 0xFF;
            break; 
        case 9:
            SegByte = 0xEF;
            break; 
        case 10:
            SegByte = 0x80;
            break; 
    }
    return SegByte;
}