#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"

EthernetNetIf eth(
  IpAddr(192,168,1,2), //IP Address
  IpAddr(255,255,255,0), //Network Mask
  IpAddr(192,168,1,1), //Gateway
  IpAddr(192,168,1,1)  //DNS
);

TCPSocket tcp;

void onTCPSocketEvent(TCPSocketEvent e)
{
    switch(e)
    {
        case TCPSOCKET_CONNECTED:
            printf("Connected\n");
        break;
        
        case TCPSOCKET_ACCEPT:
            printf("Accepted\n");
        break;
        
        case TCPSOCKET_READABLE:
            printf("Readable\n");
        break;
        
        case TCPSOCKET_WRITEABLE:
            printf("Writeable\n");
        break;
        
        case TCPSOCKET_CONTIMEOUT:
            printf("Timeout\n");
        break;
        
        case TCPSOCKET_CONRST:
            printf("Reset\n");
        break;
        case TCPSOCKET_CONABRT:
            printf("Aborted\n");
        break;
        
        case TCPSOCKET_ERROR:
            printf("Error\n");
        break;
        
        case TCPSOCKET_DISCONNECTED:
            printf("Disconnected\n");
            tcp.close();
        break;    
    }
}

int main() 
{
    printf("Welcome to wireFUSE\n");
    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\n");
  
    tcp.setOnEvent(&onTCPSocketEvent);
    Host server(IpAddr(192, 168, 1, 1), 12345);
  
    Timer tmr;
    tmr.start();
    while(true)
    {
        Net::poll();
        if(tmr.read() > 3)
        {
            tmr.reset();
            printf("\nSocket verbinden...\n");
                  
              
            TCPSocketErr bindErr = tcp.connect(server);
            if(bindErr == 0)
            {
                printf("Socket verbunden..");
            }
            else
            {
                printf("Verbindungsfehler %i", bindErr);
            }      
            
                  
            const char* str = "Testdaten zum Senden: 1234567890abc...";
            int err = tcp.send(str, strlen(str));
            if(err < 0)
            {
                printf("Fehler beim Senden der Daten!\n");
            }
            else
            {
                 printf("Daten gesendet : %s\n", str);
            }
        }
    }
}
