#ifndef MBED_RFM12_C_H
#define MBED_RFM12_C_H

#include "string"
#include "lib_crc.h"
#include "mbed.h"

#define ADDR 0x00

//Defines der Statusregister und Interruptflags
#define RF_STATUS_RGITFFIT     (1<<15)
#define RF_STATUS_POR          (1<<14)
#define RF_STATUS_RGURFFOV     (1<<13)
#define RF_STATUS_WKUP         (1<<12)
#define RF_STATUS_EXT          (1<<11)
#define RF_STATUS_LBD          (1<<10)

enum status_t
{
    RX,
    TX,
    LISTEN
};

typedef union
{
    struct
    {
        uint8_t HI;
        uint8_t LO;
    }Byte;
    struct
    {
        uint16_t Port        : 6;
        uint16_t DestType    : 2;
        uint16_t Addresse    : 8;
    }Bit;
}header;

class RFM12
{
    public:
        RFM12(PinName irq, PinName sel, PinName sdi, PinName sdo, PinName sck);
        int RF_L4_Senden(char *buff, header h, char length);
        
    private:
        //Ports
        InterruptIn _irq;
        DigitalOut  _sel;
        DigitalOut  _sdi;
        DigitalIn   _sdo;
        DigitalOut  _sck;
     
        //Status des PHY Layers
        status_t status;
       
        //SendBuffer
        char *sbuffer;
        int sbufferlength;
        int sbufferi;
        //ReceiveBuffer
        char *rbuffer;
        int rbufferlength;
        int rbufferi;
        
        char *sbufferl3;
        char *rbufferl3;
        
        char *sbufferl4;
        char *rbufferl4;
               
        short RF_PHY_Write(short b);        
        void  RF_PHY_Send(char b);
        char  RF_PHY_Receive();
        
        void  RF_PHY_Interrupt();       
        
        int RF_PHY_Senden(char *buff, int length);
        int RF_PHY_Senden(string str);
        
        int RF_L3_Senden(char *buff, char length);
        int RF_L3_Empfangen(char *buff, char length);
        
        int RF_L4_Empfangen(char *buff, char length);
        
        int RF_P1_Empfangen(char *buff, char length);
        
        short crcadd(short crc, char b);
        
        char Hammi_EncodeHI(char b);
        char Hammi_EncodeLO(char b);
        
        char Hammi_DecodeHILO(char hi, char lo);
};

#endif