#include "mbed.h"

#define WAIT_TIME 1000
#define SAMPLE_TIME 10
#define PI 3.1415926538f

DigitalIn button(PC_13);
Serial pc(USBTX,USBRX);

uint16_t sample = 0;
uint32_t n = 0;
uint32_t n2 = 0;
int i = 0;

int main(){
    button.mode(PullUp);
    pc.baud(115200);
    while(1){
        if(button == 0){
            wait_ms(300);//per dare più tempo al bottone
            i++;
            if(i > 2) i = 0;
        }
        
        if(i == 0){             //onda a dente di sega
            sample = sample + 1310;
            if(sample == 65535) sample = 0;
        }
        
        if(i == 1){             //onda triangolare
            if(n<=25){
                sample = sample + 2621;
            }
            else{
                sample = sample - 2621;
            }
            if(n == 50){
                n = 0;
                sample = 0;
            }
            n++;
        }
        if(i == 2){             // onda sinusoidale
            float f = 0.2;
            sample = (uint16_t)32768.0f + 32767.0f * sin(2.0f*PI*f*(float)n2*SAMPLE_TIME*0.01f);
            n2++;
        }
        pc.putc(0xAA);
        pc.putc(0xBB);
        pc.putc(sample);
        pc.putc(sample>>8);
        wait_ms(SAMPLE_TIME);
    }
}