#include "mbed.h"

I2C          i2c(D14, D15);
Serial       pc(USBTX, USBRX);
const int    addr = 0x48<<1;

int main (){
    i2c.frequency(100000);
    char cmd[2];
    pc.printf("\r\nTCN75 I2C thermometer\r\n");
    cmd[0] = 0x01;
    cmd[1] = 0x00;
    i2c.write(addr, cmd, 2);
       while(1) {
           wait(1);
           cmd[0] = 0x00;
           i2c.write(addr, cmd, 1);
           i2c.read(addr, cmd, 2);
           float temp = 0.0625f*((cmd[0]<<8 | cmd[1])>>4);
           pc.printf("Temperature = %.4f C\r\n", temp);
           }    
}