#include "mbed.h"
#include "platform/mbed_thread.h"
#include "platform/CircularBuffer.h"

AnalogIn                       ain(A0);
BufferedSerial                 pc(USBTX, USBRX, 115200);
Ticker                         conv;
Thread                         t(osPriorityBelowNormal, 16 * 1024);
EventQueue                     coda;
CircularBuffer<uint16_t, 100>  buffer;
uint16_t                       ADC_data;
uint16_t                       frame_start=0xBBAA;
uint16_t*                      ptr1;
bool                           flag;

InterruptIn                    bottone(PC_13);
Mutex                          serial;

Ticker                         temp;
AnalogIn                       adc_temp(ADC_TEMP);


void read_A0 (void);
void fun (void);
void ISR (void);
void read_temp (void);
void fun2 (void);

int main()
{
    printf("Mbed OS version %d.%d.%d.\r\n", MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);
    ptr1 = &frame_start;
    t.start(callback(&coda, &EventQueue::dispatch_forever));
    conv.attach(&read_A0, 5ms);
    bottone.rise(&ISR);
    temp.attach(&read_temp, 2s);
    while(1) {
        if(flag) {
            ADC_data = ain.read_u16()>>4;
            buffer.push(ADC_data);
            flag = false;
            ThisThread::sleep_for(4ms);
        }
    }
}

void read_A0 (void)
{
    flag = true;
}

void ISR (void)
{
    coda.call(&fun);
}

void read_temp (void)
{
    coda.call(&fun2);
}

void fun (void)
{
    uint16_t   vettore[100];
    uint16_t   massimo;
    uint16_t   minimo;

    buffer.pop(vettore);
    for (int i=0; i<99; i++) {
        massimo = vettore[0];
        if (vettore[i]>massimo) {
           massimo = vettore[i];
        }
        minimo = vettore[0];
        if (vettore[i]<minimo) {
           minimo = vettore[i];
        }
    }
    float massimo2 = massimo*3.3/4096;
    float minimo2 = minimo*3.3/4096;
    serial.lock();
    printf("massimo = %1.3f,\t minimo = %1.3f\n\r" , massimo2, minimo2);
    serial.unlock();
}

void fun2(void){
    float tempp = adc_temp.read()*100;
    serial.lock();
    printf("Il valore di temperatura e': %1.3f\n\r" , tempp);   
    serial.unlock();
}