#ifndef SOFT_MPC4922_H
#define SOFT_MPC4922_H

#include "mbed.h"

class SoftMCP4922
{
public:
    /*
     * MCP4922 - soft SPI
     * param
     * [in] sck: clock pin
     * [in] sdi: data pin
     * [in] cs: chip select pin
     * [in] ldac: latch pin
     * [in] shdn: shutdown pin
     * [in] ch: output channel
     */
    SoftMCP4922( PinName sck, PinName sdi, PinName cs, PinName ldac, PinName shdn, int ch );
    
    /*
     * write_u*
     * param
     * [in] value: value(*bit)
     */
    void write_u16( unsigned short value );
    void write_u12( unsigned short value );
    void write_u10( unsigned short value );
    void write_u8( unsigned short value );

private:
    void dacControl( unsigned short value );
    
    DigitalOut m_sck;
    DigitalOut m_sdi;
    DigitalOut m_cs;
    DigitalOut m_ldac;
    DigitalOut m_shdn;
    int m_ch;
};



#endif  // SOFT_MPC4922_H