/*
 * MCP4922 (Soft SPI) Library
 * 2013 Magnetone
 */
 
#include "SoftMCP4922.h"

SoftMCP4922::SoftMCP4922( PinName sck, PinName sdi, PinName cs, PinName ldac, PinName shdn, int ch):
    m_sck( sck ),
    m_sdi( sdi ),
    m_cs( cs ),
    m_ldac( ldac ),
    m_shdn( shdn ),
    m_ch( ch )
{
    
    m_shdn = 1; // non shutdown
    m_sck = 0;  // init
    
    // out vcc/2
    write_u12( 2048 );
    
}

void SoftMCP4922::write_u16( unsigned short value )
{
    dacControl( value >> 5 );
}

void SoftMCP4922::write_u12( unsigned short value )
{
    dacControl( value );
}

void SoftMCP4922::write_u10( unsigned short value )
{
    dacControl( value << 2 );
}

void SoftMCP4922::write_u8( unsigned short value )
{
    dacControl( value << 4 );
}

// DAC control function
void SoftMCP4922::dacControl( unsigned short value )
{
     int i ;

    // dac setting start
    m_cs = 0;
    m_ldac = 1;
    
    // channel select
    if( m_ch == 0 ){
        m_sdi = 0;
    }else{
        m_sdi = 1;
    }
    m_sck = 1;
    m_sck = 0;
    
    // vref buffer on
    m_sdi = 1;
    m_sck = 1;
    m_sck = 0;
    
    // output gain = 1
    m_sdi = 1;
    m_sck = 1;
    m_sck = 0;
    
    // analog output enable
    m_sdi = 1;
    m_sck = 1;
    m_sck = 0;
     
    // DAC data out
    for( i=11 ; i>=0 ; i-- ){
        if( ( ( value >> i ) & 0x1 ) == 1 )
            m_sdi = 1;
        else
            m_sdi = 0;
        m_sck = 1;
        m_sck = 0;
    }

    // analog out
    m_cs = 1;
    m_ldac = 0;
    
}

