#include "mbed.h"
#include "ESP_8266.h"
//#define DEBUG
 
char tr_data[256];
Serial *pwifi;  
DigitalOut *pCH_PD;
DigitalOut *pled;

//------------
Timeout ift;
RxWiFi_t rx_wifi;

//-----------
void ift_isr()
{
rx_wifi.event=1;
}  

//---------------------
void RxWiFi_interrupt()
{
    while(pwifi->readable()) {
        rx_wifi.buffer[rx_wifi.in] = pwifi->getc();
        ift.attach(ift_isr, 0.01);
        if(rx_wifi.event==0 && rx_wifi.in<(RXWIFI_BUFFER_SIZE-1) )
            rx_wifi.in = (rx_wifi.in + 1);
    }
}
//----------------------------------------------------
void IniWiFi(Serial *pw,DigitalOut *pcs,DigitalOut *pl)
{  
    pCH_PD=pcs;
    pled=pl;
    pwifi=pw;
    
    *pCH_PD=0;
    pwifi->baud(115200);
    pwifi->attach(&RxWiFi_interrupt, Serial::RxIrq);
    *pCH_PD=1;
    rx_wifi.event=0;
    rx_wifi.cipdinfo=0;
    while(rx_wifi.event==0) {    
        wait_ms(25);
        *pled=!*pled;
    }
    rx_wifi.event=0;
    rx_wifi.in=0;
    rx_wifi.app=0;
}  
  
//------------------------------------
void WriteWiFi(uint8_t *sbuf, int len)
{
    if(pwifi->writeable()) {
        for (int i=0; i<len; i++)
            pwifi->putc(sbuf[i]);
    }
}
 
//----------------------------------
void SendToWiFi_(char *data,int len)
{
    pwifi->printf("AT+CIPSEND=%d\r\n",len);
    while(rx_wifi.event==0) wait_us(10);
    rx_wifi.in =0;
    rx_wifi.event=0;
    WriteWiFi((uint8_t *)data,len);
}   

//-----------------------
void WiFiDataProcessing()
{
    char *bptr,*aptr,*pptr;
    char data[256];
    
 if(rx_wifi.event){
    rx_wifi.app=0;
    rx_wifi.buffer[rx_wifi.in]=0;
    bptr=strstr(rx_wifi.buffer,"+IPD");
//-----------recive UDP data--------------------------
    if(bptr!=NULL) {
        bptr=strchr(rx_wifi.buffer,',');
        bptr++;
        rx_wifi.len=strtol(bptr,&aptr,10);
        bptr=strchr(aptr,':');
        pptr=strchr(aptr,','); 
        if((bptr>pptr)&&(bptr!=NULL)&&(pptr!=NULL)) {
            aptr++;
            pptr=strchr(aptr,',');
            *pptr=0;
            pptr++;
            *bptr=0;
        } else
            bptr=NULL;
        if (bptr!=NULL) {
            bptr++;
            for (int i=0; i<rx_wifi.len; i++)
                data[i]=bptr[i];
            rx_wifi.answer=wifi_executeCallback(data);//<------action------
 #ifdef  DEBUG
                pc_printfCallback("wifi_executeCallback");
#endif           
            rx_wifi.app=1; 
            rx_wifi.ipd=0;
            if(strcmp(rx_wifi.IPaddr,aptr)!=0) {
                sprintf(rx_wifi.IPaddr,"%s",aptr);
                sprintf(rx_wifi.UDPport,"%s",pptr);
                rx_wifi.event=0;
                rx_wifi.in =0;
                pwifi->printf("AT+CIPCLOSE\r\n");
                while(rx_wifi.event==0) wait_us(10);
                rx_wifi.buffer[rx_wifi.in]=0;
#ifdef  DEBUG
                pc_printfCallback(rx_wifi.buffer);
#endif
                rx_wifi.event=0;
                rx_wifi.in =0;
                pwifi->printf("AT+CIPSTART=\"UDP\",\"%s\",%s,1112,2\r\n",rx_wifi.IPaddr,rx_wifi.UDPport);
                rx_wifi.ipd=1;
                
            } else if(rx_wifi.answer==0) {
/*//---------------------information feedback -----------------                 
                        rx_wifi.event=0;
                        rx_wifi.in =0;
                        SendToWiFi_(data,rx_wifi.len);
*/                        
                    }
        }
    } else {
//-----------------------------recive Modem answer-------------------------------------------
#ifdef  DEBUG
        if(rx_wifi.buffer[0]<128)
            pc_printfCallback(rx_wifi.buffer);
#else
        if(rx_wifi.buffer[0]<128){
            char *endptr=strstr(rx_wifi.buffer,"AT+CIFSR");   
            if(endptr!=NULL) 
                pc_printfCallback(rx_wifi.buffer);//pc.printf("%s",rx_wifi_buffer);  
        }   
#endif
        if(strstr(rx_wifi.buffer,"WIFI GOT IP")!=NULL) {
            pwifi->printf("AT+CIPSTART=\"UDP\",\"192.168.255.255\",1112,1112,2\r\n");
        } else if(strstr(rx_wifi.buffer,"CONNECT")!=NULL) {
                 if (rx_wifi.cipdinfo==0) {
                   rx_wifi.cipdinfo=1;
                   pwifi->printf("AT+CIPDINFO=1\r\n");
                 } else  if(rx_wifi.ipd) {
                           rx_wifi.ipd=0;
                           rx_wifi.event=0;
                           rx_wifi.in =0;
                           if(data[1]==' ')
                               SendToWiFi_(data,rx_wifi.len);
                         } else
                             pwifi->printf("AT+CIFSR\r\n");
             }
    }
    rx_wifi.in =0;
    rx_wifi.event=0;
  }  
}
 
//--------------------
void SendResponseWiFi()
{
 if(rx_wifi.app){
    if (rx_wifi.answer&&rx_wifi.ipd==0){  
        ResponseWiFiCallback(tr_data,rx_wifi.answer);
        if(rx_wifi.answer)
            SendToWiFi_(tr_data,strlen(tr_data));
    }  
    rx_wifi.answer=0;    
    rx_wifi.app=0;        
 } 
} 
    