#ifndef ESP_8266_h
#define ESP_8266_h
#include "mbed.h"

  const uint16_t RXWIFI_BUFFER_SIZE = 256*5;
  typedef struct {
    char IPaddr[16];
    char UDPport[8];
    volatile uint16_t in;       // Circular buffer pointers, volatile makes read-modify-write atomic
    uint8_t event;      
    uint8_t app;
    uint8_t answer; 
    uint8_t ipd;   
    uint8_t cipdinfo; 
    int len;
    char buffer[RXWIFI_BUFFER_SIZE];  //1280
  } RxWiFi_t;

void WriteWiFi(uint8_t *sbuf, int len);
void WiFiDataProcessing();
void IniWiFi(Serial *pwifi,DigitalOut *pCH_PD,DigitalOut *pled);//IniWiFi(); 
void SendResponseWiFi();

uint8_t wifi_executeCallback(char *buffer);
void pc_printfCallback(char *buffer);
void ResponseWiFiCallback(char *data,uint8_t answer);

extern RxWiFi_t rx_wifi;

/************************************************************************************************
*                                                EXAMPLE                                        *
*  !!!!!!!!!!!!!!!!!!!     Befor connection with AP, set AT+CWMODE_DEF=1   !!!!!!!!!!!!!!!!!!!!!*
*************************************************************************************************/
/*
#include "mbed.h"
 
#include "ESP_8266.h" 
const int buffer_size = 255;    // might need to increase buffer size for high baud rates

  typedef struct {
    volatile uint8_t in;       // Circular buffer pointers, volatile makes read-modify-write atomic
    uint8_t event;      
    uint8_t app;
    uint8_t answer; 
    char buffer[buffer_size];  
  } RxPc;   

//@************************************************************************
//@*                         Interface                                    *
//@************************************************************************
Serial wifi_modem(PB_6,PB_7);
DigitalOut CH_PD(PA_8);
DigitalOut wifi_led(LED1);

 CH_PD=0;
 IniWiFi(&wifi_modem,&CH_PD,&wifi_led);


//@************************************************************************
//@*                         Global variables                             *
//@************************************************************************

  RxWiFi_t rx_wifi;

//@************************************************************************
//@*                         functions                            *
//@************************************************************************
void WriteWiFi(uint8_t *sbuf, int len);
void WiFiDataProcessing();
void IniWiFi(Serial *pwifi,DigitalOut *pCH_PD,DigitalOut *pled);//IniWiFi(); 
void SendResponseWiFi();

uint8_t wifi_executeCallback(char *buffer);
void pc_printfCallback(char *buffer);
void ResponseWiFiCallback(char *data,uint8_t answer);

//@************************************************************************
//@*                         main                            *
//@************************************************************************

    while(1) { 
        ...................
        WiFiDataProcessing();
        SendResponseWiFi(); 
        ..................
    }

//@***********************************************************************
//@*                         CALLBACK                                    *
//@***********************************************************************
void pc_printfCallback(char *buffer)
{
  pc.printf("%s",buffer);
}    

//--------------------------------------------------
void ResponseWiFiCallback(char *data,uint8_t answer)
{
 Response(answer,data);
 //---------------------information feedback -----------------
 //if(data[0]=='0')
 //    rx_wifi.answer=0;
}

//---------------------------------------
 uint8_t wifi_executeCallback(char *buffer)
{
 WIFI_exist=1;
 PC_exist=0;
 return execute(buffer);  
}   
*/

#endif