#ifndef __LSM303D_MY_H
#define __LSM303D_MY_H

#include "mbed.h"

#define M_PI 3.14159265358979323846
//#define RADIAN  M_PI/180.0

//---------------------ecompas/accelerometer--------------- 
#define I2C_ADDR   0x3a
#define  WHO_AM_I  0x0F //ID=0x49
#define  CTRL1     0x20
#define  CTRL2     0x21
//Linear acceleration FS (full-scale) in CTRL2:
//       ±2g - 0.061 mg/LSB default
//       ±4g 0.122
//       ±6g 0.183
//       ±8g 0.244
//       ±16g 0.732
#define  CTRL3      0x22
#define  CTRL4      0x23
#define  CTRL5      0x24
#define  CTRL6      0x25
//Magnetic FS  (full-scale) in CTRL6:
//       ±2gauss 0.080 mgauss/LSB
//       ±4gauss 0.160
//       ±8gauss 0.320
//       ±12gauss 0.479
#define  CTRL7       0x26

#define  STATUS_M    0x07
#define  OUT_X_L_M   0x08 
#define  OUT_X_H_M   0x09 
#define  OUT_Y_L_M   0x0A 
#define  OUT_Y_H_M   0x0B 
#define  OUT_Z_L_M   0x0C 
#define  OUT_Z_H_M   0x0D 
#define  OUT_X_L_A   0x28
#define  OUT_Y_L_A   0x2a
#define  OUT_Z_L_A   0x2c

char EcompLSM303D_GetID(I2C *ecomp);
void EcompLSM303D_Ini(I2C *ecomp);
void EcompLSM303D_Get_M_Axis(I2C *ecomp,int16_t* m);
void EcompLSM303D_Get_A_Axis(I2C *ecomp,double* a);
uint16_t CalculateBearing(int  x,  int  y);
#endif
