#define ONE_PULSE 3000
#define ZERO_PULSE 1000
#define ONE_PULSE_TH 1000
#define ZERO_PULSE_TH 700
#define IR_BUFF_MAX  2

#define IR_KEY_1 0xee917fc0
#define IR_KEY_2 0xee51bfc0
#define IR_KEY_3 0xee11ffc0
#define IR_KEY_4 0xeed13fc0
#define IR_KEY_5 0xefd03fc0
#define IR_KEY_6 0xef10ffc0
#define IR_KEY_7 0xfe01ffc0
#define IR_KEY_8 0xfa857fc0
#define IR_KEY_9 0xfd827fc0

#define IR_KEY_0     0xf9867fc0 
#define IR_KEY_STAR  0xfa45bfc0
#define IR_KEY_SHARP 0xfc837fc0

#define IR_KEY_U 0xf9c63fc0
#define IR_KEY_D 0xeb54bfc0
#define IR_KEY_L 0xfdc23fc0
#define IR_KEY_R 0xe956bfc0
#define IR_KEY_OK 0xf8c73fc0

//------ IR Reciver time-------
Timeout IrReciverTimer;
Timer  duration_timer;

//------ IR Reciver global-----
uint8_t IrRecEn=1;
uint8_t NewMode=0;
uint8_t NewParametr=0;
uint8_t bit_counter;
uint8_t NewChar;
uint16_t f_cnt,r_cnt;
uint32_t IrChar,IrChar_t;
char IRmessage_buff[16];
uint8_t buff_cnt;
uint8_t mode_ir;
uint16_t parametr_t;
//-----------------
 void IRmessage_t()
 {
 char c;   
 char *endptr;    
        if (NewChar){
           //pc.printf("0x%8x %d\r\n",IrChar,bit_counter);
           switch(IrChar){
                case IR_KEY_1:
                    c='1';
                    break;
                case IR_KEY_2:
                    c='2';
                     break;
                case IR_KEY_3:
                    c='3';
                    break;
                case IR_KEY_4:
                    c='4';
                    break;
                case IR_KEY_5:
                    c='5';
                    break;
                case IR_KEY_6:
                    c='6';
                    break;
                case IR_KEY_7:
                    c='7';
                    break;
                case IR_KEY_8:
                    c='8';
                    break;                   
                case IR_KEY_9:
                    c='9';
                    break;                    
                case IR_KEY_0:
                    c='0';
                    break;          
                case IR_KEY_STAR:
                    c='*';
                    break;    
                case IR_KEY_SHARP:
                    c='#';
                    break;                              
                case IR_KEY_U:
                    c='U';
                    break;          
                case IR_KEY_D:
                    c='D';
                     break;          
                case IR_KEY_L:
                    c='L';
                    break;          
                case IR_KEY_R:
                    c='R';
                    break;          
                case IR_KEY_OK:
                    c='O';
                    break;          
           }           
           NewChar=0;
           bit_counter=0;
           switch(c){
                case '*':
                    IRmessage_buff[buff_cnt]='.';
                    mode_ir=strtol(IRmessage_buff,&endptr,10);
                    buff_cnt=0;
                    NewMode=1;
                    break;
                case '#':
                    IRmessage_buff[buff_cnt]='.';
                    parametr_t=strtol(IRmessage_buff,&endptr,10);
                    buff_cnt=0;   
                    NewParametr=1;                                
                    break; 
                case 'U':
                    mode_ir=11;
                    NewMode=1;                    
                    break;  
                case 'D':
                    mode_ir=12;    
                    NewMode=1;                                    
                    break;                              
                 case 'L':
                    mode_ir=13;
                    NewMode=1;                                        
                    break;   
                case 'R':
                    mode_ir=14;   
                    NewMode=1;                                     
                    break; 
                case 'O':
                    mode_ir=1;  
                    NewMode=1;                                     
                    break;  
                default:
                    if(buff_cnt<15){
                       IRmessage_buff[buff_cnt]=c;
                       buff_cnt++;
                    }
                    break;                                                                                               
          }
        }   
}                                                                                                                                            
                  
//-----IR Reciver ISR-----
void IrReciver_risingedge()
{
    duration_timer.start();
}

//----------------------
void IrReciverTimer_isr()
{
    IrChar=IrChar_t;
    IrChar_t=0;
    if(bit_counter==36)    
        NewChar=1;
    else
        bit_counter=0;
    IRmessage_t(); 
}

//--------------------------
void IrReciver_fallingedge()
{
    uint16_t duration_time;
    if(IrRecEn) {
         duration_timer.stop();
         duration_time=duration_timer.read_us();
         duration_timer.reset();

         IrChar_t=IrChar_t>>1;
         if (duration_time>ONE_PULSE_TH) 
            IrChar_t=IrChar_t|0x80000000;
         else  
             IrChar_t=IrChar_t&0x7fffffff;      
         bit_counter++;
         IrReciverTimer.detach();     
         IrReciverTimer.attach_us(&IrReciverTimer_isr,50000);   
    }
}
        
//--------------------------------------
void TRremoteIni(InterruptIn  *IrReciver)
{
  IrReciver->rise(&IrReciver_risingedge);
  IrReciver->fall(&IrReciver_fallingedge);
  bit_counter=0;
  IrChar=0;
  IrChar_t=0; 
  IrRecEn=1;
  NewChar=0; 
  buff_cnt=0;
}  
 
//--------------------------------------------- 
 void IRmessage(uint8_t *mode,uint8_t *mode_ind,uint16_t *parametr)
{
 if(NewMode){
    *mode=*mode_ind=mode_ir;
    NewMode=0;
 }
 if(NewParametr){  
    *parametr=parametr_t; 
    NewParametr=0;        
 }
}
 
 
