#include "mbed.h"

class StatusLed {
public:
    StatusLed(PinName led, int itoMilliseconds) 
    : _led(led), _active(false), _ito(itoMilliseconds) {
    }
    void update(bool activity) {
        if(activity) {
            touch();
        } else if (_active && _timer.read_ms() >= _ito) {
            _active = false;
            _timer.stop();
            _timer.reset();
        }
    }
private:
    void touch() {
        if(_active) {
            _timer.reset();
        } else {
            _active = true;
            _timer.start();
        }
    }
    DigitalOut _led;
    Timer _timer;
    bool _active;
    unsigned _ito;
};

inline int Forward(Serial &in, Serial &out) {
    if(in.readable() && out.writeable()) {
        out.putc(in.getc());
        return 1;
    }
    return 0;
}

int main() {
    
    unsigned ito = 100;

    StatusLed led1(LED1, ito);
    StatusLed led2(LED2, ito);
    
    Serial m3pi(p9,p10);
    m3pi.baud(115200);
    
    Serial wixel(p28,p27);
    wixel.baud(115200);
    
    while(1) {
       led1.update(Forward(m3pi, wixel));
       led2.update(Forward(wixel, m3pi));
    }
}
