// TEST 3


//Biblioteke
#include "mbed.h"
#include "mb_pins.h"

#include "platform/mbed_thread.h"
#include "MQTTClientMbedOs.h"

#include "Adafruit_GFX.h"
#include "Adafruit_GFX_Config.h"
#include "Adafruit_SSD1306.h"


#define BLINKING                                                             250
#define VOLTAGE_SCALER                                                      3.3f
#define TIMEOUT                                                             1000    
#define MAX_NETWORKS                                                          15
#define PRINTF_DELAY_MS  


#define I2C_REAL_ADD                                                        0x3c
#define I2C_ADDRESS                                            I2C_REAL_ADD << 1
#define OLED_HEIGHT                                                           64
#define OLED_WIDTH                                                           128

//Globalne promenljive
WiFiInterface *wifi;
TCPSocket socket;
MQTTClient client(&socket);
MQTT::Message message;

I2C i2c(PB_14,PB_13);
Adafruit_SSD1306_I2c myOled(i2c,PB_5,I2C_ADDRESS,OLED_HEIGHT,OLED_WIDTH);

char* topic = "pubpim";
char* topic_sub = "subpim";
const char* hostname = "broker.hivemq.com";
int arrivedcount = 0;
int port = 1883;



//Funkcije
int scan_networks(WiFiInterface *wifi)
{
    myOled.begin();
    myOled.setTextCursor(5,5);
    myOled.setTextSize(15);
    
    printf("Scan:\n");
    myOled.writeChar('S');
    myOled.writeChar('c');
    myOled.writeChar('a');
    myOled.writeChar('n');
    myOled.writeChar(':');
    myOled.display();
    
    int count = wifi->scan(NULL, 0);
    if (count <= 0)
    {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
    count = count < MAX_NETWORKS ? count : MAX_NETWORKS;
    

    WiFiAccessPoint *ap = new WiFiAccessPoint[count];
    count = wifi->scan(ap, count);
    
    if (count <= 0) 
    {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
    
    printf("%d networks available.\n", count);
    delete[] ap;
    return count;
}
 void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    //printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    printf("Message from the browser: %.*s\r\n", message.payloadlen, (char*)message.payload);
    ++arrivedcount;
}



//Glavni program
int main()
{
    wifi = WiFiInterface::get_default_instance();
    if (!wifi) {
        printf("ERROR\n");
        return -1;
    }
    
    
    int count = scan_networks(wifi);
    if (count == 0) {
        printf("\n");
        return -1;
    }
    
    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        printf("\nConnection error: %d\n", ret);
        return -1;
    }
    printf("Success\n\n"); 
    
    
    //Ostvarivanje konekcije
    socket.open(wifi);
    socket.connect(hostname, port);
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "pim-30";
    client.connect(data);
    
    // Connect
    int rc = 0;
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\r\n", rc);
 
    if ((rc = client.subscribe(topic_sub, MQTT::QOS2, messageArrived)) != 0)
        printf("rc from MQTT subscribe is %d\r\n", rc);
    
}