/* 
    Prikazana vrednost ne odgovara onome sto se moze cuti.
    Predpostavka je da je tako zbog ispunjenosti perioda.
    Zvuk je ovde digitalan i razmenjuje vrednosti izmedju maksimalne i 0.
    Sto znaci da ce za visokofrekfentni talas (sa malom periodom) i sa velikim
    duty cycleom vise izgledati kao konstantna vrednost. Ovakva kostantna vrednost
    ne dovodi do primetnog talasanja vazduha.
*/


// Biblioteke
#include<stdio.h>
#include<math.h>
#include"mbed.h"

// Definisanje makroa
#define FREQ 19800

// Globalne promenjlive
int temp = -1, pot1_value = -1;
AnalogIn pot1(PA_0);
AnalogIn pot2(PA_1);
InterruptIn btn1(PC_9);
PwmOut buzzer(PA_11);
BusOut display(PA_10, PA_9, PA_8, PB_10, PB_5, PB_4, PB_3, PA_5);
DigitalOut SEL1(PC_7);
DigitalOut SEL2(PB_6);
int num[10] = { 0b01000000, //0
                0b01111001, //1
                0b00100100, //2
                0b00110000, //3
                0b00011001, //4
                0b00010010, //5
                0b00000010, //6
                0b01111000, //7
                0b00000000, //8
                0b00010000}; //9

// Deklaracija funkcija
void ISR_btn1(void);

// Glavni program
int main()
{
       // set up
       btn1.fall(&ISR_btn1);
       
       buzzer.period( 1.0/( (FREQ*pot2.read()) + 200 ) );
       buzzer.write(0.0);
       SEL1.write(1);
       SEL2.write(1);
       
       // deo koda koji se iznova izvrsava
       while(true)
       {
           
           buzzer.period( 1.0/( (FREQ*pot2.read()) + 200 ) );
           buzzer.write(pot1.read()* 1.0);
           
           pot1_value = pot1.read()*100;
           
           if( abs( temp - pot1_value) > 5)
           {
               temp = -1;
           }
           
           if(temp < 0)
           {
                SEL1.write(1);
                SEL2.write(1);
                wait_ms(10);
           }
           else
           {
                if(temp<10)
                {
                    SEL2.write(1);
                    SEL1.write(0);
                    display.write(num[temp%10]);
                    wait_ms(10);    
                }
                else
                {
                    SEL1.write(1);
                    SEL2.write(0);
                    display.write((num[(temp/10)%10]));
              
                    wait_ms(10);
              
                    SEL2.write(1);
                    SEL1.write(0);
                    display.write(num[temp%10]);
                    
                    wait_ms(10);
                }
            }
           
           
       }
}

// Definicija funkcija
void ISR_btn1()
{
    temp = (pot1.read()*100.0f);
    temp = temp%100;
}