#include "mbed.h"

AnalogIn v_bat(PB_1);
AnalogIn v_5(PC_2);
AnalogIn v_3(PF_4);
//A2 and A3 for top and base battery charges respectively
//cut off voltage at 3.3v or higher - technical max is 4.2v,
//but there is no built-in hardware cutoff!

//MON_VBATT PB_1
//MON_5V0   PC_2
//MON_3V3   PF_4

int main() {
    Serial pc(USBTX, USBRX);
    while(1) {
        float analogue5V = v_5.read();
        float analogue33V = v_3.read();
        float analogueValue = v_bat.read();
        pc.printf("Voltage readings are: VBATT: %f 5V0: %f 3V3: %f\n\r", analogueValue, analogue5V, analogue33V);
        wait_ms(1000);
    }
}